<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		URL::redirect('invoice.php');
	}

	$id = intval($_GET['id']);

	if(isset($_POST['submit']) && $_POST['submit'] == 'invoice') {
		if(isset($_POST['method']) && $_POST['method'] == 'update') {
			// HTML::pre($_POST);
			$result = Invoice::update($id);
			if($result && !$result['error']) {
				//HTML::script('alert("แก้ไขใบวางบิลสำเร็จ");');
				//URL::redirect('invoice-update.php?id='.$id);
			}
			// HTML::pre($result);
		}
	}

	$data = Invoice::detail($id);
	if(!$data) {
		HTML::script('alert("ไม่พบข้อมูล");');
		URL::redirect('invoice.php');
	}

	$customer_show = false;
	if(isset($_GET['customer-id']) && intval($_GET['customer-id']) > 0) {
		$customer_show = Customer::detail(intval($_GET['customer-id']));
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>แก้ไขใบวางบิล<?=(intval($data['sequence']) > 0 ? ' (เล่มที่: '.intval($data['sequence']).')' : '');?></h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="panel panel-warning">
					<div class="panel-body">
						<form method="get" class="form-inline">
							<input type="hidden" name="id" value="<?=$data['id'];?>">
							<label for="">วันที่</label>
							<input type="date" name="date-from" class="form-control" value="<?=isset($_GET['date-from']) ? $_GET['date-from'] : '';?>">
							&emsp;
							<label for="">ถึง</label>
							<input type="date" name="date-to" class="form-control" value="<?=isset($_GET['date-to']) ? $_GET['date-to'] : '';?>">

							<br/>
							<br/>

							<label for="">ลูกค้า</label>
							<input type="hidden" id="customer-id-hidden" name="customer-id" value="<?=($customer_show && $customer_show['id'] ? $customer_show['id'] : '');?>" />
							<input class="form-control center number" id="customer-id" type="text" placeholder="ค้นหาลูกค้า" size="50" value="<?=($customer_show  ? ($customer_show['name'].($customer_show['nickname'] ? ' ('.$customer_show['nickname'].')' : '')) : '');?>" autocomplete="off"/>
							&emsp;
							<label for="">ภาษี</label>
							<select name="tax" class="form-control" id="" required>
								<option value="all" selected>ทั้งหมด</option>
								<option value="tax" <?=isset($_GET['tax']) && $_GET['tax'] == 'tax'? 'selected' : '';?> >คิดภาษี</option>
								<option value="notax" <?=isset($_GET['tax']) && $_GET['tax'] == 'notax'? 'selected' : '';?> >ไม่คิดภาษี</option>
							</select>

							<br/>
							<br/>

							<button class="btn btn-primary" type="submit">
								<i class="fa fa-search"></i>
								ค้นหา
							</button>
							<button type="button" class="btn btn-warning" onclick="window.location='<?=URL::to('bill.php');?>'">
								<i class="fa fa-undo"></i>
								ล้าง
							</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<form method="post">
			<input type="hidden" name="submit" value="invoice" />
			<input type="hidden" name="method" value="update" />
			<input type="hidden" name="sequence" value="<?=intval($data['sequence']);?>" />
			<input type="hidden" name="invoice-id" value="<?=$id;?>" />
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="panel panel-warning">
						<div class="panel-heading center">
							<h3 class="center">รายการ</h3>
						</div>
						<table class="table table-hover b-table">
							<?php
								$_POST['invoice_id'] = $data['id'];
								$bills = Bill::lists();

								if(sizeof($bills) == 0) {
									echo '<tr class="heading">';
										echo '<td class="center" colspan="8">ไม่พบข้อมูลการขายที่ค้นหาในระบบ</td>';
									echo '</tr>';
								}
								else {
									echo '<tr class="heading">
										<th width="10%"><input id="select-all" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-size="small" data-on="เลือกทั้งหมด" data-off="ไม่เลือก" data-onstyle="success" data-offstyle="danger" checked/></th>
										<th width="5%">เลขที่บิล</th>
										<th width="10%">วันที่</th>
										<th width="35%">ลูกค้า</th>
										<th width="5%">ภาษี</th>
										<th width="15%">สุทธิ</th>
										<th width="5%">ดู</th>
										<th width="5%">พิมพ์</th>
										<th width="5%">ภาษี</th>
									</tr>';
									$cnt = 0;
									$total = 0;
									foreach ($bills as $key => $bill) {
										if(intval($bill['invoiced']) == intval($data['id'])) {
											++$cnt;
											$total += floatval($bill['total']);
										}

										$customer = Customer::detail($bill['customer_id']);

										echo '<tr>';
											echo '<th><input data-total="'.$bill['total'].'" class="check-bill" name="bill['.$bill['id'].']" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-size="small" data-on="<i class=\'fa fa-check\'></i>" data-off="<i class=\'fa fa-close\'>" data-onstyle="success" '.(intval($bill['invoiced']) == intval($data['id']) ? 'checked' : '').'/></th>';
											echo '<td class="center">'.$bill['sequence'].'</td>';
											echo '<td>'.ThaiDate::toThaiDate($bill['created_at'], 'd M Y').'</td>';
											echo '<td>'.$customer['name'].($customer['nickname'] ? ' ('.$customer['nickname'].')' : '').'</td>';
											echo '<td class="center">'.($bill['tax_value'] > 0 ? ($bill['tax_value'] % 1 == 0 ? intval($bill['tax_value']) : number_format($bill['tax_value'], 2)).' %' : '-').'</td>';
											echo '<td class="right">'.number_format($bill['total'], 2).'</td>';

											echo '<td class="center">
												<a href="'.URL::to('bill-detail.php?id='.$bill['id']).'" target="_blank" style="color: #5bc0de;">
													<i class="fa fa-eye fa-button"></i>
												</a>
											</td>';

											echo '<td class="center">
												<a href="'.URL::to('bill-print.php?id='.$bill['id']).'" target="_blank">
													<i class="fa fa-print fa-button"></i>
												</a>
											</td>';
											echo '<td class="center">
												<a href="'.URL::to('bill-print-tax.php?id='.$bill['id']).'" target="_blank">
													ภาษี
												</a>
											</td>';
										echo '</tr>';
									}
									echo '<tr class="heading">
										<th colspan="5">รวมที่เลือก <span id="bill-count">'.number_format($cnt).'</span> บิล</th>
										<th class="right" id="grand-total">'.number_format($total, 2).'</th>
										<td colspan="2"></td>
									</tr>';
								}
							?>
						</table>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
					<div class="form-group">
						<?php
							$customer_invoice = Customer::detail($data['customer_id']);
						?>
						<label for="">ลูกค้า *</label>
						<input type="hidden" name="customer-id" value="<?=intval($data['customer_id']);?>" />
						<input class="form-control number" type="text" placeholder="ค้นหาลูกค้า" size="50" autocomplete="off" value="<?=($customer_invoice  ? ($customer_invoice['name'].($customer_invoice['nickname'] ? ' ('.$customer_invoice['nickname'].')' : '')) : '');?>" readonly />
					</div>
				</div>
				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
					<div class="form-group">
						<label for="">พนักงาน *</label>
						<select class="form-control" name="salesman-id" id="salesman-id" required>
							<option value="" disabled selected>-- เลือกพนักงานขาย --</option>
							<?php
								$salesmans = Salesman::lists();

								if(sizeof($salesmans) > 0) {
									$cnt = 0;
									foreach ($salesmans as $key => $salesman) {
										echo '<option value="'.$salesman['id'].'" '.($salesman['id'] == $data['salesman_id'] ? 'selected' : '').'>'.$salesman['title'].$salesman['firstname'].' '.$salesman['lastname'].($salesman['nickname'] ? ' ('.$salesman['nickname'].')' : '').'</option>';;
									}
								}
							?>
						</select>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
					<div class="form-group">
						<label for="">ข้อมูลใบวางบิล *</label>
						<textarea name="name" class="form-control" id="" cols="30" rows="2" placeholder="ข้อมูลใบวางบิล" style="resize: none;" required><?=isset($data['name']) ? $data['name'] : '';?></textarea>
					</div>
					<div class="form-group center">
						<button type="reset" class="btn btn-warning">
							<i class="fa fa-undo"></i>
							ล้าง
						</button>
						<button type="submit" class="btn btn-success" id="save-invoice">
							<i class="fa fa-plus"></i>
							แก้ไขใบวางบิล
						</button>
					</div>
				</div>
			</div>
		</form>
	</div>
	<script type="text/javascript">
		function calTotal() {
			let grand_total = 0;
			$('.check-bill:checked').each(function() {
				grand_total += parseFloat($(this).attr('data-total'));

			});

			$('#grand-total').html(number_format(grand_total, 2));
			$('#bill-count').html(number_format($('.check-bill:checked').length));

			if($('.check-bill:checked').length == 0) {
				$('#save-invoice').attr('disabled', 'disabled');
			}
			else {
				$('#save-invoice').removeAttr('disabled');
			}
		}

		$(document).ready(function() {
			$('.check-bill').change(function() {
				calTotal();
			});

			$('#select-all').change(function() {
				$('.check-bill').bootstrapToggle($(this).prop('checked') ? 'on' : 'off')

				calTotal();
			});

			calTotal();

			$('#customer-id').focus(function() {
				$(this).select();
			});

			$('#customer-id').keyup(function(e) {
				if(e.which != 13) {
					$('#customer-id-hidden').val(void(0));
				}

				let v = $(this).val().trim();

				$('#customer-id').autocomplete({
					delay: 100,
					source: '<?=URL::to('customer-get.php?search=');?>'+v,
					minLength: 1,
					select: function(event, ui) {
						console.log("Selected: " + ui.item.name + " aka " + ui.item.id);
						$('#customer-id-hidden').val(ui.item.id);
					},
					position: {
						my: 'right bottom',
						at: 'right top'
					}
				});
			});
		});
	</script>
	<?php
		if(isset($result)) {
			if($result['error']) {
				echo HTML::inputAlert('textarea[name="name"]', 'danger', 'ช้อมูลไม่ถูกต้อง');
			}
			else {
				echo HTML::inputAlert('textarea[name="name"]', 'success', 'แก้ไขใบวางบิลสำเร็จ');
			}
		}
	?>
</body>
</html>
