<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		HTML::script('alert("ไม่พบข้อมูล");window.close();');
	}

	$id = intval($_GET['id']);

	$data = Invoice::detail($id);

	$salesman = Salesman::detail($data['salesman_id']);
	$customer = Customer::detail($data['customer_id']);
	
	$title = 'Receipt-'.str_replace('.', '', $customer['name']).'-'.str_replace('.', '', $customer['nickname']).'-'.intval($data['sequence']);
?>
<!DOCTYPE html>
<html>
<?php include 'head-print.html'; ?>
<body>
	<table width="100%">
		<tr>
			<th colspan="2">
				ใบเสร็จรับเงิน/ใบกำกับภาษี
			</th>
		</tr>
		<tr>
			<td>
				<?=$salesman['title'].$salesman['firstname'].' '.$salesman['lastname'];?>
			</td>
			<td class="right">
				<?=($data['number'] ? 'เล่มที่ '.number_format($data['number']) : '');?>
			</td>
		</tr>
		<tr>
			<td>
				<?=$salesman['address'];?>
			</td>
			<td class="right">
				เล่มที่ <?=intval($data['sequence']);?>
			</td>
		</tr>
		<tr>
			<td>
				โทรศัพท์ : <?=($salesman['phone'] ? $salesman['phone'] : '-');?>&emsp;
				มือถือ : <?=($salesman['mobile'] ? $salesman['mobile'] : '-');?>&emsp;
			</td>
			<td class="right">
				<?=ThaiDate::toThaiDate($data['created_at'], 'd M Y');?>
			</td>
		</tr>
		<tr>
			<td>
				เลขประจำตัวผู้เสียภาษี : <?=($salesman['fax'] ? $salesman['fax'] : '-');?>
			</td>
		</tr>	
	</table>
	<br/>
	<table width="100%">
		<tr>
			<th class="bdt bdl bdr bdb" style="padding-left: 5px;">
				
			</th>
		</tr>
		<tr>
			<td class="bdl bdr bdb">
				ชื่อที่อยู่ลูกค้า :<br> <?=$customer['name'];?> <br> <?=$customer['address'];?>
			</td>
		</tr>
	</table>
	<table width="100%">
		<tr>
			<td width="20%" class="center bdl bdr bdb">ลำดับ</td>
			<td width="60%" class="center bdr bdb">รายการ</td>
			<td width="20%" class="center bdr bdb">จำนวนเงิน</td>
			
		</tr>
		<?php
			$_POST['invoice_id'] = $data['id'];
			$bills = Bill::lists();
            $customer['nickname'];
			$cnt = 0;
			$total = 0;

			if(sizeof($bills) == 0) {
				echo '<tr>';
					echo '<td class="center bdl bdr bdb" colspan="4">ไม่พบข้อมูลการขายในระบบ</td>';
				echo '</tr>';
			}
			else {
				foreach ($bills as $key => $bill) {
					
					$total += floatval($bill['total']);
					
				}
			}
			
			$grand_total = $total;
			

			echo '<tr>';
				echo '<td class="center bdl bdr bdb">1</td>';
				echo '<td class="bdl bdr bdb">'.$data['name'].'<br>'.$customer['nickname'].'</td>';
				
				echo '<td class="right bdr bdb">'.number_format($grand_total, 2).'</td>';
			echo '</tr>';


			$margin = 26;
			if($cnt < $margin) {
				$rows = $margin-$cnt;
				for($i = 0; $i < $rows; ++$i) {
					echo '<tr class="holder">';
						echo '<td class="bdl bdr">&nbsp;</td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
					echo '</tr>';
				}
			}
			
		?>
		<tr>
			<td class="center bdl bdt bdb">
			</td>
			<td class="center bdt bdr bdb">
				มูลค่าสินค้า
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($grand_total/1.07, 2);?>
			</td>
		</tr>
		<tr>
			<td class="center bdl bdt bdb">
			</td>
			<td class="center bdt bdr bdb">
				ภาษีมูลค่าเพิ่ม 7%
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($grand_total*7/107, 2);?>
			</td>
		</tr>
		<tr>
			<td class="center bdl bdt bdb">
			</td>
			<td class="center bdt bdr bdb">
				ยอดรวมสุทธิ
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($grand_total, 2);?>
			</td>
		</tr>
		<tr>
			<td colspan="4" class="center vat bdt bdl bdr bdb">
				จำนวนเงินเป็นตัวอักษร <?=BahtText::toBahtText($grand_total);?>
			</td>
		</tr>
		<tr>
			<td colspan="4" class="center vat bdt bdl bdr bdb">
				ข้าพเจ้าได้รับเงินตามรายการข้างต้นไว้เป็นที่เรียบร้อยแล้ว
			</td>
		</tr>
	</table>
	<table width="100%">
		<tr>
			<td class="center bdl" width="50%">
				
			</td>
			<td class="center bdr" width="50%">
				<br/>
				ลงชื่อ .................................................. ผู้รับเงิน
			</td>
		</tr>
		<tr>
			<td class="center bdl"></td>
			<td class="center bdr">(..................................................)</td>
		</tr>
		<tr>
			<td class="center bdl bdb"></td>
			<td class="center bdr bdb">วันที่ ........../........../..........<br/><br/></td>
		</tr>
	</table>
	<script type="text/javascript">
		$().ready(function(){
			window.print();
			setTimeout(function(){
				window.close();
			}, 1);
		});
	</script>
</body>
</html>