<?php
class Validator {
	public static function validate($fields, $type) {
		// for aplication/json
		// var_dump(json_decode(file_get_contents('php://input')));
		switch ($type) {
			case 'get':
				$form_var = $_GET;
				break;
			case 'post':
				$form_var = $_POST;
				break;
			case 'request':
				$form_var = $_REQUEST;
				break;
			default:
				return false;
				break;
		}

		foreach ($fields as $key => $field) {
			$form_key = str_ireplace('_', '-', $key);
			//echo $form_key.'<br>';

			if(!array_key_exists($form_key, $form_var) || !isset($form_var[$form_key])) {
				if($field['type'] == 'bool') {
					continue;
				}
				if($field['required']) {
					return false;
				}
				else {
					continue;
				}

			}

			switch ($field['type']) {
				case 'bool':
					if(!isset($form_var[$form_key]) || is_bool($form_var[$form_key])) {
						continue;
					}
					elseif (is_string($form_var[$form_key])) {
						$value = strtolower(trim($form_var[$form_key]));
						if($value == 'on' || $value === 'true' || $value === 'false') {
							continue;
						}
					}
					return false;
					break;
				case 'number':
					if(is_numeric($form_var[$form_key])) {
						continue;
					}
					return false;
					break;
				case 'string':
					if(is_string($form_var[$form_key])) {
						if($field['required'] && !strlen($form_var[$form_key])) {
							return false;
						}
						continue;
					}
					return false;
					break;
				case 'array':
					if(is_array($form_var[$form_key])) {
						if($field['required'] && !sizeof($form_var[$form_key])) {
							return false;
						}
						continue;
					}
					if(is_string($form_var[$form_key])) {
						if($field['required'] && !sizeof(json_decode(json_encode($form_var[$form_key])))) {
							return false;
						}
						continue;
					}
					return false;
					break;
				// case 'object':
				// 	if(is_array($form_var[$form_key])) {
				// 		if($field['required'] && !sizeof($form_var[$form_key])) {
				// 			return false;
				// 		}
				// 		continue;
				// 	}
				// 	if(is_string($form_var[$form_key]) && is_object(json_decode(json_encode($form_var[$form_key])))) {
				// 		echo 'helo';
				// 		if($field['required'] && !sizeof(get_object_vars(json_decode(json_encode($form_var[$form_key]))))) {
				// 			return false;
				// 		}
				// 		continue;
				// 	}
				// 	return false;
				// 	break;
				default:
					# code...
					break;
			}
		}
		return true;
	}

	public static function get_insert_data_string($fields, $type, $addition_datas = []) {
		switch ($type) {
			case 'get':
				$form_var = $_GET;
				break;
			case 'post':
				$form_var = $_POST;
				break;
			case 'request':
				$form_var = $_REQUEST;
				break;
			default:
				return false;
				break;
		}

		$datas = [];
		foreach ($fields as $key => $field) {
			if(isset($addition_datas[$key])) {
				array_push($datas, '"'.trim($addition_datas[$key]).'"');
				continue;
			}

			$form_key = str_ireplace('_', '-', $key);

			if(!isset($form_var[$form_key])) {
				if(isset($field['default'])) {
					switch ($field['type']) {
						case 'bool':
							$data = intval($field['default']);
							break;
						case 'string':
							$data = '"'.$field['default'].'"';
							break;
						default:
							$data = $field['default'];
							break;
					}
				}
				else {
					$data = 'NULL';
				}
				array_push($datas, $data);
				continue;
			}
			if($field['type'] == 'bool') {
				array_push($datas, $form_var[$form_key] ? 1 : 0);
				continue;
			}
			if($field['type'] == 'number') {
				array_push($datas, $form_var[$form_key]);
				continue;
			}
			if($field['type'] == 'string') {
				array_push($datas, '"'.DB::escape($form_var[$form_key]).'"');
			}
		}
		return join(',', $datas);
	}

	public static function get_update_data_string($fields, $type, $addition_datas = []) {
		switch ($type) {
			case 'get':
				$form_var = $_GET;
				break;
			case 'post':
				$form_var = $_POST;
				break;
			case 'request':
				$form_var = $_REQUEST;
				break;
			default:
				return false;
				break;
		}
		$datas = [];
		foreach ($fields as $key => $field) {
			if(isset($addition_datas[$key])) {
				array_push($datas, '"'.trim($addition_datas[$key]).'"');
				continue;
			}

			$form_key = str_ireplace('_', '-', $key);

			if(!isset($form_var[$form_key])) {
				if(isset($field['default'])) {
					switch ($field['type']) {
						case 'bool':
							$data = intval($field['default']);
							break;
						case 'string':
							$data = '"'.$field['default'].'"';
							break;
						default:
							$data = $field['default'];
							break;
					}
				}
				else {
					$data = 'NULL';
				}
				array_push($datas, $key.'='.$data);
				continue;
			}
			if($field['type'] == 'bool') {
				array_push($datas, $key.'='.$form_var[$form_key] ? 1 : 0);
				continue;
			}
			if($field['type'] == 'number') {
				array_push($datas, $key.'='.$form_var[$form_key]);
				continue;
			}
			if($field['type'] == 'string') {
				array_push($datas, $key.'="'.DB::escape($form_var[$form_key]).'"');
			}
		}
		return join(',', $datas);
	}

	public static function get_insert_field_string($fields) {
		return join(',', array_keys($fields));
	}
}
?>
