<?php
class Invoice {
	const TABLE_NAME = 'invoice';

	const FIELDS = [
		'name' => [
			'type' => 'string',
			'required' => true,
		],
		'number' => [
			'type' => 'number',
			'required' => false,
		],
		'salesman_id' => [
			'type' => 'number',
			'required' => true,
		],
		'customer_id' => [
			'type' => 'number',
			'required' => true,
		],
		'sequence' => [
			'type' => 'number',
			'required' => true,
		],
	];

	public static function create() {
		$sequence = DB::query('SELECT (IFNULL(COUNT(1),0) + 1) AS sequence FROM invoice WHERE customer_id = {customer_id}', [
			'customer_id' => intval($_POST['customer-id']),
		]);
		$_POST['sequence'] = $sequence[0]['sequence'];

		// var_dump($_POST);

		if(isset($_POST['invoice-number'])) {
			$max_invoice = DB::query('SELECT IFNULL(max(number), 0) AS max_number FROM {table}', [
				'table' => self::TABLE_NAME,
			]);

			if($max_invoice && sizeof($max_invoice) == 1) {
				$_POST['number'] = intval($max_invoice[0]['max_number'])+1;
			}
		}
		if(!self::validate()) {
			return [
				'error' => true,
				'result' => 'invalid'
			];
		}

		DB::execute('BEGIN');

		$result = DB::execute('INSERT INTO {table} ('.Validator::get_insert_field_string(self::FIELDS).') VALUES ('.Validator::get_insert_data_string(self::FIELDS, 'post').')', [
			'table' => self::TABLE_NAME,
		]);

		if(!$result) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'insert_invoice_error'
			];
		}

		$id = DB::get_last_id();

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'insert_bill_error'
			];
		}

		foreach ($_POST['bill'] as $bill_id => $value) {
			if(intval($bill_id) <= 0 || $value != 'on') {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'bill_id_error'
				];
			}

			$invoice_bill = DB::execute('UPDATE bill SET invoiced = {invoiced} WHERE id = {id}', [
				'invoiced' => $id,
				'id' => $bill_id,
			]);

			if(!$invoice_bill) {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'update_bill_error'
				];
			}

			DB::execute('UPDATE bill SET updated_at = NOW() WHERE id = {id}', [
				'id' => $bill_id,
			]);
		}

		DB::execute('COMMIT');

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function update($id) {
		// if(!self::validate()) {
		// 	return [
		// 		'error' => true,
		// 		'result' => 'invalid'
		// 	];
		// }

		if(!isset($_POST['name']) || trim($_POST['name']) == '' || !isset($_POST['salesman-id']) || intval($_POST['salesman-id']) <= 0 || !isset($_POST['customer-id']) || intval($_POST['customer-id']) <= 0) {
			return [
				'error' => true,
				'result' => 'invalid'
			];
		}

		$id = intval($id);

		DB::execute('BEGIN');

		$result = DB::execute('UPDATE {table} 
		SET name = "{name}", salesman_id = {salesman_id}, customer_id = {customer_id} 
		WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'name' => trim($_POST['name']),
			'salesman_id' => intval($_POST['salesman-id']),
			'customer_id' => intval($_POST['customer-id']),
			'id' => $id,
		]);

		if(!$result) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		$clear_bill = DB::execute('UPDATE bill SET invoiced = 0, updated_at = NOW() WHERE invoiced = {id}', [
			'id' => $id,
		]);

		if(!$result) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'clear_bill_error'
			];
		}

		////

		foreach ($_POST['bill'] as $bill_id => $value) {
			if(intval($bill_id) <= 0 || $value != 'on') {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'bill_id_error'
				];
			}

			$invoice_bill = DB::execute('UPDATE bill SET invoiced = {invoiced} WHERE id = {id}', [
				'invoiced' => $id,
				'id' => $bill_id,
			]);

			if(!$invoice_bill) {
				DB::execute('ROLLBACK');
				return [
					'error' => true,
					'result' => 'update_bill_error'
				];
			}

			DB::execute('UPDATE bill SET updated_at = NOW() WHERE id = {id}', [
				'id' => $bill_id,
			]);
		}

		DB::execute('UPDATE {table} SET updated_at = NOW() WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			DB::execute('ROLLBACK');
			return [
				'error' => true,
				'result' => 'invoice_notfound'
			];
		}

		DB::execute('COMMIT');

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function delete($id) {
		$id = intval($id);

		return DB::execute('DELETE FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);
	}

	public static function detail($id) {
		$id = intval($id);

		$result = DB::query('SELECT *
			FROM {table}
			WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		return sizeof($result) == 0 ? false : $result[0];
	}

	public static function lists($start=0, $limit=PERPAGE, $order_by='id', $order='DESC') {
		$filter_date = '1';
		$filter_customer = '';

		if(isset($_GET['date-from']) && trim($_GET['date-from']) != '') {
			$filter_date = 'AND DATE(created_at) >= DATE("'.trim($_GET['date-from']).'")';
		}else if(isset($_GET['date-to']) && trim($_GET['date-to']) != '') {
			$filter_date = 'AND DATE(created_at) <= DATE("'.trim($_GET['date-to']).'")';
		}

		if(isset($_GET['date-from']) && trim($_GET['date-from']) != '' && isset($_GET['date-to']) && trim($_GET['date-to']) != ''){
			$filter_date = 'AND (DATE(created_at) BETWEEN DATE("'.trim($_GET['date-from']).'") AND DATE("'.trim($_GET['date-to']).'") )';
		}

		if(isset($_GET['customer-id']) && intval($_GET['customer-id']) > 0) {
			$filter_customer = ' AND customer_id = '.intval($_GET['customer-id']);
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_date.' '.$filter_customer.' ORDER BY {order_by} {order}', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function search($start=0, $limit=PERPAGE, $order_by='id', $order='ASC') {
		$filter_name = '0';
		$filter_nickname = '0';

		if(isset($_GET['search'])) {
			$get_search = trim($_GET['search']);
			if($get_search != '') {
				$filter_name = 'name LIKE "%'.$get_search.'%"';
				$filter_nickname = 'nickname LIKE "%'.$get_search.'%"';
			}
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_name.' OR '.$filter_nickname.' ORDER BY {order_by} {order}', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function get() {
		if(isset($_GET['barcode'])) {
			$get_search = trim($_GET['barcode']);
			if($get_search != '') {
				$filter_barcode = 'barcode LIKE "%'.$get_search.'%"';
			}
		}

		$result =  DB::query('SELECT * FROM {table} WHERE '.$filter_barcode.' LIMIT 1', [
			'table' => self::TABLE_NAME,
		]);

		return sizeof($result) == 0 ? (object)[] : $result[0];
	}

	public static function validate() {
		return Validator::validate(self::FIELDS, 'post');
	}
}
?>
