<?php
class FileManager
{
	const MAX_SIZE = 50000000;
	const DISALLOW_TYPE = '/php|js|asp|cgi|html/i';

	private static function createDirectory($path){
		if(!is_dir($path)){
			if(mkdir($path, 0755, true)){
				return true;
			}
			return false;
		}
		return true;
	}

	public static function checkFileSize($fn){
		if(filesize($fn)<=self::MAX_SIZE){
			return true;
		}
		return false;
	}

	public static function getFileInfo($fn){
		$info = pathinfo($fn);
		$info['size'] = filesize($fn).' Bytes';
		$info['type'] = filetype($fn);
		$info['mimetype'] = mime_content_type($fn);
		$info['realpath'] = realpath($fn);
		return $info;
	}

	public static function requestFile($index){
		if( !isset($_FILES[$index]) )return false;
		return $_FILES[$index];
	}

	public static function uploadFile($f, $target, $newFilename){
		$fileExtension = explode('.', $f['name']);
		$fileExtension = $fileExtension[sizeof($fileExtension)-1];
		$tmpFileInfo = self::getFileInfo($f['tmp_name']);
		if(preg_match(self::DISALLOW_TYPE, $tmpFileInfo['mimetype'])){
			return false;
		}
		if(preg_match(self::DISALLOW_TYPE, $fileExtension)){
			return false;
		}
		if(!is_dir($target)){
			if(!self::createDirectory($target)){
				return false;
			}
		}
		$move = $target.$newFilename.'.'.$fileExtension;
		if(file_exists($move)){
			return false;
		}
		if(!move_uploaded_file($f['tmp_name'], $move)){
			return false;
		}
		return $newFilename.'.'.$fileExtension;
	}


	//del with duplicate name
	// $dupname = glob($prefix.'.*');

		
	// 	if(isset($dupname) && sizeof($dupname)>0){
	// 		//var_dump($dupname);
	// 		foreach ($dupname as $dupfilename) {
	// 		    if(file_exists($dupfilename)){
	// 				unlink($dupfilename);
	// 			}
	// 		}
	// 	}
}


?>